<?php
require_once 'config/config.php';

try {
    $database = new Database();
    $db = $database->getConnection();

    $sql = file_get_contents('add_survey_system.sql');
    $statements = array_filter(array_map('trim', explode(';', $sql)));

    foreach ($statements as $statement) {
        if (!empty($statement) && !str_starts_with($statement, '--')) {
            try {
                $db->exec($statement);
                echo "Executed: " . substr($statement, 0, 50) . "..." . PHP_EOL;
            } catch (PDOException $e) {
                echo "Error: " . $e->getMessage() . PHP_EOL;
            }
        }
    }
    echo "Survey system database migration completed." . PHP_EOL;
} catch (Exception $e) {
    echo "Migration failed: " . $e->getMessage() . PHP_EOL;
}
?>