<?php
require_once 'config/config.php';

$database = new Database();
$db = $database->getConnection();

// Get recent jobs for display
$stmt = $db->prepare("
    SELECT j.*, c.name as company_name, c.logo as company_logo, cat.name as category_name 
    FROM jobs j 
    LEFT JOIN companies c ON j.company_id = c.id 
    LEFT JOIN job_categories cat ON j.category_id = cat.id 
    WHERE j.status = 'active' AND c.status = 'approved'
    ORDER BY j.created_at DESC 
    LIMIT 6
");
$stmt->execute();
$recent_jobs = $stmt->fetchAll();

// Get job categories
$stmt = $db->prepare("SELECT * FROM job_categories ORDER BY name");
$stmt->execute();
$categories = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo SITE_NAME; ?> - Find Your Dream Job</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
    <style>
        .job-card-modern {
            transition: transform 0.2s ease-in-out;
        }
        
        .job-card-modern:hover {
            transform: translateY(-2px);
        }
        
        .job-item {
            border-radius: 8px !important;
            border: 1px solid #e3e6f0 !important;
            transition: all 0.3s ease;
        }
        
        .job-item:hover {
            border-color: #dc3545 !important;
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.1) !important;
        }
        
        .job-title {
            font-size: 1.25rem;
            line-height: 1.4;
            color: #dc3545 !important;
        }
        
        .job-title:hover {
            color: #c82333 !important;
        }
        
        .job-location {
            font-size: 0.95rem;
            color: #6c757d !important;
            margin-bottom: 1rem;
        }
        
        .job-meta .badge {
            font-size: 0.8rem;
            padding: 0.5rem 0.75rem;
            border-radius: 20px;
            font-weight: 500;
            background-color: #f8f9fa !important;
            color: #495057 !important;
            border: 1px solid #dee2e6 !important;
        }
        
        .job-arrow {
            font-size: 1.1rem;
            color: #adb5bd;
            transition: color 0.2s ease;
        }
        
        .job-item:hover .job-arrow i {
            color: #dc3545;
        }
        
        .jobs-container-home {
            max-width: 100%;
        }
        
        @media (min-width: 768px) {
            .jobs-container-home {
                max-width: 900px;
                margin: 0 auto;
            }
        }
        
        .company-logo {
            width: 50px;
            height: 50px;
            object-fit: contain;
            border-radius: 8px;
            border: 1px solid #e9ecef;
            background: white;
            padding: 4px;
        }
        
        .company-logo-placeholder {
            width: 50px;
            height: 50px;
            background: #f8f9fa;
            border: 1px solid #e9ecef;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #6c757d;
        }
    </style>
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container">
            <a class="navbar-brand" href="index.php">
                
                <img src="assets\images\cefgroup.png" alt="sanpc logo" width="350" height="100">
            </a>
            
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav me-auto">
                    <li class="nav-item">
                        <a class="nav-link active" href="index.php">Home</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="jobs.php">Browse Jobs</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="companies.php">Companies</a>
                    </li>
                </ul>
                
                <ul class="navbar-nav">
                    <?php if (isLoggedIn()): ?>
                        <?php if ($_SESSION['user_type'] === 'admin'): ?>
                            <li class="nav-item">
                                <a class="nav-link" href="admin/dashboard.php">Admin Dashboard</a>
                            </li>
                        <?php elseif ($_SESSION['user_type'] === 'company'): ?>
                            <li class="nav-item">
                                <a class="nav-link" href="company/dashboard.php">Company Dashboard</a>
                            </li>
                        <?php elseif ($_SESSION['user_type'] === 'candidate'): ?>
                            <li class="nav-item">
                                <a class="nav-link" href="candidate/dashboard.php">My Profile</a>
                            </li>
                        <?php endif; ?>
                        <li class="nav-item">
                            <a class="nav-link" href="auth/logout.php">Logout</a>
                        </li>
                    <?php else: ?>
                        <li class="nav-item">
                            <a class="nav-link" href="auth/login.php">Login</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="auth/register.php">Register</a>
                        </li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="hero-section text-white">
        <div class="container">
            <div class="row align-items-center min-vh-75">
                <div class="col-lg-8 mx-auto text-center hero-content">
                    <h1 class="display-3 fw-bold mb-4">Find Your Dream Job Today</h1>
                    <p class="lead mb-5 fs-4">Connect with top companies and discover amazing career opportunities that match your skills and aspirations in a modern, professional environment.</p>
                    <div class="d-flex flex-column flex-sm-row gap-3 justify-content-center">
                        <a href="jobs.php" class="btn btn-light btn-lg px-5 py-3">
                            <i class="fas fa-search me-2"></i>Browse Jobs
                        </a>
                        <a href="auth/register.php" class="btn btn-outline-light btn-lg px-5 py-3">
                            <i class="fas fa-user-plus me-2"></i>Join as Candidate
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Job Search Section -->
    <section class="py-5">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="card shadow-sm">
                        <div class="card-body p-4">
                            <form action="jobs.php" method="GET">
                                <div class="row g-3">
                                    <div class="col-md-4">
                                        <input type="text" class="form-control" name="keyword" placeholder="Job title, skills...">
                                    </div>
                                    <div class="col-md-3">
                                        <select class="form-select" name="category">
                                            <option value="">All Categories</option>
                                            <?php foreach ($categories as $category): ?>
                                                <option value="<?php echo $category['id']; ?>"><?php echo htmlspecialchars($category['name']); ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                    <div class="col-md-3">
                                        <input type="text" class="form-control" name="location" placeholder="Location">
                                    </div>
                                    <div class="col-md-2">
                                        <button type="submit" class="btn btn-primary w-100">
                                            <i class="fas fa-search"></i> Search
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Recent Jobs Section -->
    <section class="py-5 bg-light">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="fw-bold">Latest Job Opportunities</h2>
                <p class="text-muted">Discover the newest positions from top companies</p>
            </div>
            
            <div class="jobs-container-home">
                <?php foreach ($recent_jobs as $job): ?>
                    <div class="job-card-modern mb-3">
                        <a href="job-details.php?id=<?php echo $job['id']; ?>" class="text-decoration-none">
                            <div class="card border-0 shadow-sm job-item">
                                <div class="card-body p-4">
                                    <div class="d-flex justify-content-between align-items-start">
                                        <div class="d-flex align-items-start">
                                            <!-- Company Logo -->
                                            <div class="me-3">
                                                <?php if ($job['company_logo']): ?>
                                                    <img src="<?php echo UPLOAD_URL . 'logos/' . $job['company_logo']; ?>" 
                                                         alt="<?php echo htmlspecialchars($job['company_name']); ?>" 
                                                         class="company-logo">
                                                <?php else: ?>
                                                    <div class="company-logo-placeholder">
                                                        <i class="fas fa-building"></i>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                            
                                            <!-- Job Details -->
                                            <div class="flex-grow-1">
                                                <h5 class="job-title text-danger mb-1 fw-bold">
                                                    <?php echo htmlspecialchars($job['title']); ?>
                                                </h5>
                                                <p class="text-primary mb-2 fw-medium">
                                                    <?php echo htmlspecialchars($job['company_name']); ?>
                                                </p>
                                                <p class="job-location text-muted mb-3 fs-6">
                                                    <i class="fas fa-map-marker-alt me-1"></i>
                                                    <?php echo htmlspecialchars($job['location']); ?>
                                                </p>
                                                <div class="job-meta d-flex flex-wrap gap-3">
                                                    <span class="job-category badge bg-light text-dark border">
                                                        <i class="fas fa-briefcase me-1"></i>
                                                        <?php echo htmlspecialchars($job['category_name'] ?: 'General'); ?>
                                                    </span>
                                                    <span class="job-type badge bg-light text-dark border">
                                                        <i class="fas fa-clock me-1"></i>
                                                        <?php echo ucfirst(str_replace('-', ' ', $job['employment_type'])); ?>
                                                    </span>
                                                    <span class="job-level badge bg-light text-dark border">
                                                        <i class="fas fa-layer-group me-1"></i>
                                                        <?php echo ucfirst($job['experience_level']); ?>+ years
                                                    </span>
                                                    <?php if ($job['salary_min'] || $job['salary_max']): ?>
                                                        <span class="job-salary badge bg-success text-white">
                                                            <i class="fas fa-coins me-1"></i>
                                                            <?php if ($job['salary_min'] && $job['salary_max']): ?>
                                                                R<?php echo number_format($job['salary_min']); ?> - R<?php echo number_format($job['salary_max']); ?>
                                                            <?php elseif ($job['salary_min']): ?>
                                                                From R<?php echo number_format($job['salary_min']); ?>
                                                            <?php else: ?>
                                                                Up to R<?php echo number_format($job['salary_max']); ?>
                                                            <?php endif; ?>
                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="job-arrow">
                                            <i class="fas fa-chevron-right text-muted"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </a>
                    </div>
                <?php endforeach; ?>
            </div>
            
            <div class="text-center mt-4">
                <a href="jobs.php" class="btn btn-primary btn-lg">View All Jobs</a>
            </div>
        </div>
    </section>

    <!-- Features Section -->
    <section class="py-5">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="fw-bold">Why Choose Our Platform?</h2>
            </div>
            
            <div class="row">
                <div class="col-lg-4 col-md-6 mb-4">
                    <div class="text-center">
                        <div class="feature-icon bg-primary text-white rounded-circle mx-auto mb-3">
                            <i class="fas fa-search fa-2x"></i>
                        </div>
                        <h4>Easy Job Search</h4>
                        <p class="text-muted">Find the perfect job with our advanced search and filtering options.</p>
                    </div>
                </div>
                
                <div class="col-lg-4 col-md-6 mb-4">
                    <div class="text-center">
                        <div class="feature-icon bg-success text-white rounded-circle mx-auto mb-3">
                            <i class="fas fa-users fa-2x"></i>
                        </div>
                        <h4>Top Companies</h4>
                        <p class="text-muted">Connect with leading companies and employers in your industry.</p>
                    </div>
                </div>
                
                <div class="col-lg-4 col-md-6 mb-4">
                    <div class="text-center">
                        <div class="feature-icon bg-info text-white rounded-circle mx-auto mb-3">
                            <i class="fas fa-file-alt fa-2x"></i>
                        </div>
                        <h4>Online CV Builder</h4>
                        <p class="text-muted">Create professional resumes with our built-in CV builder tool.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="bg-dark text-white py-4">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <h5><?php echo SITE_NAME; ?></h5>
                    <p class="text-muted">Connecting talented individuals with amazing opportunities.</p>
                </div>
                <div class="col-lg-6">
                    <div class="text-lg-end">
                        <p>&copy; <?php echo date('Y'); ?> <?php echo SITE_NAME; ?>. All rights reserved.</p>
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Handle hero background image fallbacks for office team image
        document.addEventListener('DOMContentLoaded', function() {
            const heroSection = document.querySelector('.hero-section');
            if (heroSection) {
                // Test if hero-office-team.jpg loads successfully
                const testImage = new Image();
                testImage.onload = function() {
                    console.log('Office team hero image loaded successfully as background');
                };
                testImage.onerror = function() {
                    console.warn('Office team hero image failed to load, using fallback');
                    // Fallback to orange gradient if local image fails
                    heroSection.style.background = `
                        linear-gradient(135deg, #FFA500 0%, #FF8C00 100%)
                    `;
                };
                testImage.src = 'assets/images/hero-office-team.jpg';
            }
        });
    </script>
</body>
</html>