<?php
require_once '../config/config.php';
requireLogin('company');

$database = new Database();
$db = $database->getConnection();
$company_id = $_SESSION['company_id'];

$candidate_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if (!$candidate_id) {
    redirect('internal-candidates.php');
}

// Get candidate details
$stmt = $db->prepare("
    SELECT c.*, 
           comp.name as company_name,
           cu_deactivated.name as deactivated_by_name,
           cu_approved.name as approved_by_name
    FROM candidates c
    LEFT JOIN companies comp ON c.company_id = comp.id
    LEFT JOIN company_users cu_deactivated ON c.deactivated_by = cu_deactivated.id
    LEFT JOIN company_users cu_approved ON c.approved_by = cu_approved.id
    WHERE c.id = ? AND c.company_id = ? AND c.candidate_type = 'internal'
");
$stmt->execute([$candidate_id, $company_id]);
$candidate = $stmt->fetch();

if (!$candidate) {
    redirect('internal-candidates.php');
}

// Get candidate's job applications
$stmt = $db->prepare("
    SELECT ja.*, j.title as job_title, j.status as job_status,
           DATE(ja.applied_at) as applied_date
    FROM job_applications ja
    JOIN jobs j ON ja.job_id = j.id
    WHERE ja.candidate_id = ? AND j.company_id = ?
    ORDER BY ja.applied_at DESC
");
$stmt->execute([$candidate_id, $company_id]);
$applications = $stmt->fetchAll();

// Get candidate's education
$stmt = $db->prepare("
    SELECT * FROM education 
    WHERE candidate_id = ? 
    ORDER BY start_date DESC
");
$stmt->execute([$candidate_id]);
$education = $stmt->fetchAll();

// Get candidate's work experience
$stmt = $db->prepare("
    SELECT * FROM work_experience 
    WHERE candidate_id = ? 
    ORDER BY start_date DESC
");
$stmt->execute([$candidate_id]);
$work_experience = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>View Internal Candidate - <?php echo SITE_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="../assets/css/style.css" rel="stylesheet">
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container-fluid">
            <a class="navbar-brand" href="../index.php">
                <i class="fas fa-briefcase me-2"></i><?php echo SITE_NAME; ?>
            </a>
            
            <div class="navbar-nav ms-auto">
                <span class="navbar-text me-3">
                    Welcome, <?php echo htmlspecialchars($_SESSION['company_name']); ?>
                </span>
                <a class="nav-link" href="../auth/logout.php">
                    <i class="fas fa-sign-out-alt me-1"></i>Logout
                </a>
            </div>
        </div>
    </nav>

    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <nav class="col-md-3 col-lg-2 sidebar">
                <div class="position-sticky">
                    <ul class="nav flex-column">
                        <li class="nav-item">
                            <a class="nav-link" href="dashboard.php">
                                <i class="fas fa-tachometer-alt me-2"></i>Dashboard
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="profile.php">
                                <i class="fas fa-building me-2"></i>Company Profile
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="jobs.php">
                                <i class="fas fa-briefcase me-2"></i>Manage Jobs
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="post-job.php">
                                <i class="fas fa-plus-circle me-2"></i>Post New Job
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="applications.php">
                                <i class="fas fa-file-alt me-2"></i>Applications
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link active" href="internal-candidates.php">
                                <i class="fas fa-user-tie me-2"></i>Internal Candidates
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="interviews.php">
                                <i class="fas fa-calendar-alt me-2"></i>Interviews
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="hr-analytics.php">
                                <i class="fas fa-chart-line me-2"></i>HR Analytics
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="change-password.php">
                                <i class="fas fa-lock me-2"></i>Change Password
                            </a>
                        </li>
                    </ul>
                </div>
            </nav>

            <!-- Main Content -->
            <main class="col-md-9 col-lg-10 px-md-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">
                        <i class="fas fa-user-tie me-2"></i>
                        Internal Candidate Details
                    </h1>
                    <div class="btn-toolbar mb-2 mb-md-0">
                        <a href="internal-candidates.php" class="btn btn-sm btn-outline-secondary">
                            <i class="fas fa-arrow-left me-1"></i>Back to List
                        </a>
                    </div>
                </div>

                <!-- Candidate Header Card -->
                <div class="card mb-4">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-3 text-center">
                                <?php if ($candidate['profile_picture']): ?>
                                    <img src="<?php echo UPLOAD_PATH; ?>profiles/<?php echo htmlspecialchars($candidate['profile_picture']); ?>" 
                                         class="rounded-circle mb-3" width="150" height="150" alt="Profile Picture">
                                <?php else: ?>
                                    <div class="bg-secondary rounded-circle mx-auto mb-3 d-flex align-items-center justify-content-center" 
                                         style="width: 150px; height: 150px;">
                                        <i class="fas fa-user fa-4x text-white"></i>
                                    </div>
                                <?php endif; ?>
                                
                                <!-- Status Badges -->
                                <div class="mb-3">
                                    <?php
                                    $approval_badge_class = '';
                                    switch ($candidate['approval_status']) {
                                        case 'pending': $approval_badge_class = 'bg-warning'; break;
                                        case 'approved': $approval_badge_class = 'bg-success'; break;
                                        case 'rejected': $approval_badge_class = 'bg-danger'; break;
                                    }
                                    
                                    $employment_badge_class = '';
                                    switch ($candidate['employment_status']) {
                                        case 'active': $employment_badge_class = 'bg-success'; break;
                                        case 'inactive': $employment_badge_class = 'bg-secondary'; break;
                                        case 'terminated': $employment_badge_class = 'bg-danger'; break;
                                    }
                                    ?>
                                    <div>
                                        <span class="badge <?php echo $approval_badge_class; ?> me-2">
                                            <?php echo ucfirst($candidate['approval_status']); ?>
                                        </span>
                                    </div>
                                    <div class="mt-2">
                                        <span class="badge <?php echo $employment_badge_class; ?>">
                                            <?php echo ucfirst($candidate['employment_status']); ?>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-9">
                                <h3><?php echo htmlspecialchars($candidate['first_name'] . ' ' . $candidate['last_name']); ?></h3>
                                <p class="text-muted mb-3">Internal Candidate</p>
                                
                                <div class="row">
                                    <div class="col-md-6">
                                        <h5>Personal Information</h5>
                                        <table class="table table-sm table-borderless">
                                            <tr>
                                                <td><strong>Email:</strong></td>
                                                <td><?php echo htmlspecialchars($candidate['email']); ?></td>
                                            </tr>
                                            <tr>
                                                <td><strong>Phone:</strong></td>
                                                <td><?php echo htmlspecialchars($candidate['phone'] ?? 'Not provided'); ?></td>
                                            </tr>
                                            <tr>
                                                <td><strong>Employee ID:</strong></td>
                                                <td><?php echo htmlspecialchars($candidate['employee_id'] ?? 'Not assigned'); ?></td>
                                            </tr>
                                            <tr>
                                                <td><strong>Date of Birth:</strong></td>
                                                <td><?php echo $candidate['date_of_birth'] ? date('M d, Y', strtotime($candidate['date_of_birth'])) : 'Not provided'; ?></td>
                                            </tr>
                                            <tr>
                                                <td><strong>Gender:</strong></td>
                                                <td><?php echo $candidate['gender'] ? ucfirst($candidate['gender']) : 'Not specified'; ?></td>
                                            </tr>
                                            <tr>
                                                <td><strong>Nationality:</strong></td>
                                                <td><?php echo $candidate['nationality'] ? ucfirst(str_replace('_', ' ', $candidate['nationality'])) : 'Not specified'; ?></td>
                                            </tr>
                                        </table>
                                    </div>
                                    <div class="col-md-6">
                                        <h5>Employment Details</h5>
                                        <table class="table table-sm table-borderless">
                                            <tr>
                                                <td><strong>Current Position:</strong></td>
                                                <td><?php echo htmlspecialchars($candidate['current_position'] ?? 'Not specified'); ?></td>
                                            </tr>
                                            <tr>
                                                <td><strong>Department:</strong></td>
                                                <td><?php echo htmlspecialchars($candidate['current_department'] ?? 'Not specified'); ?></td>
                                            </tr>
                                            <tr>
                                                <td><strong>Application Date:</strong></td>
                                                <td><?php echo date('M d, Y', strtotime($candidate['created_at'])); ?></td>
                                            </tr>
                                            <tr>
                                                <td><strong>Approved Date:</strong></td>
                                                <td><?php echo $candidate['approved_at'] ? date('M d, Y', strtotime($candidate['approved_at'])) : 'Not approved'; ?></td>
                                            </tr>
                                            <tr>
                                                <td><strong>Approved By:</strong></td>
                                                <td><?php echo htmlspecialchars($candidate['approved_by_name'] ?? 'System'); ?></td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <?php if ($candidate['employment_status'] !== 'active'): ?>
                    <!-- Deactivation Details Card -->
                    <div class="card mb-4">
                        <div class="card-header bg-warning">
                            <h5 class="mb-0">
                                <i class="fas fa-exclamation-triangle me-2"></i>
                                <?php echo ucfirst($candidate['employment_status']); ?> Status Details
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-4">
                                    <strong>Status Changed:</strong><br>
                                    <?php echo $candidate['deactivated_at'] ? date('M d, Y \a\t g:i A', strtotime($candidate['deactivated_at'])) : 'Unknown'; ?>
                                </div>
                                <div class="col-md-4">
                                    <strong>Changed By:</strong><br>
                                    <?php echo htmlspecialchars($candidate['deactivated_by_name'] ?? 'System'); ?>
                                </div>
                                <div class="col-md-4">
                                    <strong>Current Status:</strong><br>
                                    <span class="badge bg-<?php echo $candidate['employment_status'] === 'inactive' ? 'secondary' : 'danger'; ?> fs-6">
                                        <?php echo ucfirst($candidate['employment_status']); ?>
                                    </span>
                                </div>
                            </div>
                            <?php if ($candidate['deactivation_reason']): ?>
                                <hr>
                                <div>
                                    <strong>Reason:</strong><br>
                                    <div class="alert alert-light mt-2">
                                        <?php echo nl2br(htmlspecialchars($candidate['deactivation_reason'])); ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>

                <!-- Job Applications Card -->
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0">
                            <i class="fas fa-file-alt me-2"></i>Job Applications
                            <span class="badge bg-primary ms-2"><?php echo count($applications); ?></span>
                        </h5>
                    </div>
                    <div class="card-body">
                        <?php if (empty($applications)): ?>
                            <div class="text-center py-4">
                                <i class="fas fa-file-alt fa-3x text-muted mb-3"></i>
                                <p class="text-muted">No job applications found.</p>
                            </div>
                        <?php else: ?>
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Job Title</th>
                                            <th>Applied Date</th>
                                            <th>Status</th>
                                            <th>Job Status</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($applications as $application): ?>
                                            <tr>
                                                <td>
                                                    <strong><?php echo htmlspecialchars($application['job_title']); ?></strong>
                                                </td>
                                                <td><?php echo date('M d, Y', strtotime($application['applied_date'])); ?></td>
                                                <td>
                                                    <?php
                                                    $status_class = '';
                                                    switch ($application['status']) {
                                                        case 'applied': $status_class = 'bg-info'; break;
                                                        case 'longlisted': $status_class = 'bg-primary'; break;
                                                        case 'shortlisted': $status_class = 'bg-warning'; break;
                                                        case 'interviewed': $status_class = 'bg-secondary'; break;
                                                        case 'hired': $status_class = 'bg-success'; break;
                                                        case 'rejected': $status_class = 'bg-danger'; break;
                                                        default: $status_class = 'bg-light text-dark'; break;
                                                    }
                                                    ?>
                                                    <span class="badge <?php echo $status_class; ?>">
                                                        <?php echo ucfirst($application['status']); ?>
                                                    </span>
                                                </td>
                                                <td>
                                                    <span class="badge bg-<?php echo $application['job_status'] === 'active' ? 'success' : 'secondary'; ?>">
                                                        <?php echo ucfirst($application['job_status']); ?>
                                                    </span>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Education Card -->
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0">
                            <i class="fas fa-graduation-cap me-2"></i>Education
                            <span class="badge bg-primary ms-2"><?php echo count($education); ?></span>
                        </h5>
                    </div>
                    <div class="card-body">
                        <?php if (empty($education)): ?>
                            <div class="text-center py-4">
                                <i class="fas fa-graduation-cap fa-3x text-muted mb-3"></i>
                                <p class="text-muted">No education information available.</p>
                            </div>
                        <?php else: ?>
                            <?php foreach ($education as $edu): ?>
                                <div class="border-bottom pb-3 mb-3">
                                    <div class="row">
                                        <div class="col-md-8">
                                            <h6 class="mb-1"><?php echo htmlspecialchars($edu['degree'] ?? 'Degree not specified'); ?></h6>
                                            <p class="mb-1 text-primary"><?php echo htmlspecialchars($edu['institution']); ?></p>
                                            <?php if ($edu['field_of_study']): ?>
                                                <p class="mb-1"><?php echo htmlspecialchars($edu['field_of_study']); ?></p>
                                            <?php endif; ?>
                                            <?php if ($edu['grade']): ?>
                                                <small class="text-success"><strong>Grade: </strong><?php echo htmlspecialchars($edu['grade']); ?></small>
                                            <?php endif; ?>
                                        </div>
                                        <div class="col-md-4 text-md-end">
                                            <small class="text-muted">
                                                <?php 
                                                $start_year = $edu['start_date'] ? date('Y', strtotime($edu['start_date'])) : 'Unknown';
                                                $end_year = $edu['end_date'] ? date('Y', strtotime($edu['end_date'])) : 'Present';
                                                echo $start_year . ' - ' . $end_year;
                                                ?>
                                            </small>
                                        </div>
                                    </div>
                                    <?php if ($edu['description']): ?>
                                        <p class="mb-0 mt-2"><small><?php echo nl2br(htmlspecialchars($edu['description'])); ?></small></p>
                                    <?php endif; ?>
                                </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Work Experience Card -->
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0">
                            <i class="fas fa-briefcase me-2"></i>Work Experience
                            <span class="badge bg-primary ms-2"><?php echo count($work_experience); ?></span>
                        </h5>
                    </div>
                    <div class="card-body">
                        <?php if (empty($work_experience)): ?>
                            <div class="text-center py-4">
                                <i class="fas fa-briefcase fa-3x text-muted mb-3"></i>
                                <p class="text-muted">No work experience information available.</p>
                            </div>
                        <?php else: ?>
                            <?php foreach ($work_experience as $work): ?>
                                <div class="border-bottom pb-3 mb-3">
                                    <div class="row">
                                        <div class="col-md-8">
                                            <h6 class="mb-1"><?php echo htmlspecialchars($work['position']); ?></h6>
                                            <p class="mb-1 text-primary"><?php echo htmlspecialchars($work['company_name']); ?></p>
                                            <?php if ($work['is_current']): ?>
                                                <span class="badge bg-success">Current Position</span>
                                            <?php endif; ?>
                                        </div>
                                        <div class="col-md-4 text-md-end">
                                            <small class="text-muted">
                                                <?php 
                                                $start_date = $work['start_date'] ? date('M Y', strtotime($work['start_date'])) : 'Unknown';
                                                if ($work['is_current'] || !$work['end_date']) {
                                                    $end_date = 'Present';
                                                } else {
                                                    $end_date = date('M Y', strtotime($work['end_date']));
                                                }
                                                echo $start_date . ' - ' . $end_date;
                                                ?>
                                            </small>
                                        </div>
                                    </div>
                                    <?php if ($work['description']): ?>
                                        <p class="mb-0 mt-2"><small><?php echo nl2br(htmlspecialchars($work['description'])); ?></small></p>
                                    <?php endif; ?>
                                </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Address Information -->
                <?php if ($candidate['address']): ?>
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="mb-0">
                                <i class="fas fa-map-marker-alt me-2"></i>Address Information
                            </h5>
                        </div>
                        <div class="card-body">
                            <p class="mb-0"><?php echo nl2br(htmlspecialchars($candidate['address'])); ?></p>
                        </div>
                    </div>
                <?php endif; ?>

            </main>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>