<?php
require_once '../config/config.php';
requireLogin('admin');

$database = new Database();
$db = $database->getConnection();

// Get statistics
$stats = [];

// Total companies
$stmt = $db->prepare("SELECT COUNT(*) as count FROM companies");
$stmt->execute();
$stats['total_companies'] = $stmt->fetch()['count'];

// Pending companies
$stmt = $db->prepare("SELECT COUNT(*) as count FROM companies WHERE status = 'pending'");
$stmt->execute();
$stats['pending_companies'] = $stmt->fetch()['count'];

// Total candidates
$stmt = $db->prepare("SELECT COUNT(*) as count FROM candidates");
$stmt->execute();
$stats['total_candidates'] = $stmt->fetch()['count'];

// Total jobs
$stmt = $db->prepare("SELECT COUNT(*) as count FROM jobs");
$stmt->execute();
$stats['total_jobs'] = $stmt->fetch()['count'];

// Active jobs
$stmt = $db->prepare("SELECT COUNT(*) as count FROM jobs WHERE status = 'active'");
$stmt->execute();
$stats['active_jobs'] = $stmt->fetch()['count'];

// Total applications
$stmt = $db->prepare("SELECT COUNT(*) as count FROM job_applications");
$stmt->execute();
$stats['total_applications'] = $stmt->fetch()['count'];

// Recent companies
$stmt = $db->prepare("SELECT * FROM companies ORDER BY created_at DESC LIMIT 5");
$stmt->execute();
$recent_companies = $stmt->fetchAll();

// Recent candidates
$stmt = $db->prepare("SELECT * FROM candidates ORDER BY created_at DESC LIMIT 5");
$stmt->execute();
$recent_candidates = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard - <?php echo SITE_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="../assets/css/style.css" rel="stylesheet">
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container-fluid">
            <a class="navbar-brand" href="../index.php">
                <i class="fas fa-briefcase me-2"></i><?php echo SITE_NAME; ?>
            </a>
            
            <div class="navbar-nav ms-auto">
                <span class="navbar-text me-3">
                    Welcome, <?php echo htmlspecialchars($_SESSION['username']); ?>
                </span>
                <a class="nav-link" href="../auth/logout.php">
                    <i class="fas fa-sign-out-alt me-1"></i>Logout
                </a>
            </div>
        </div>
    </nav>

    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <nav class="col-md-3 col-lg-2 sidebar">
                <div class="position-sticky">
                    <ul class="nav flex-column">
                        <li class="nav-item">
                            <a class="nav-link active" href="dashboard.php">
                                <i class="fas fa-tachometer-alt me-2"></i>Dashboard
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="companies.php">
                                <i class="fas fa-building me-2"></i>Manage Companies
                                <?php if ($stats['pending_companies'] > 0): ?>
                                    <span class="badge bg-warning ms-2"><?php echo $stats['pending_companies']; ?></span>
                                <?php endif; ?>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="audit-trail.php">
                                <i class="fas fa-clipboard-list me-2"></i>Audit Trail
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="candidates.php">
                                <i class="fas fa-users me-2"></i>Manage Candidates
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="jobs.php">
                                <i class="fas fa-briefcase me-2"></i>Manage Jobs
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="categories.php">
                                <i class="fas fa-tags me-2"></i>Job Categories
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="applications.php">
                                <i class="fas fa-file-alt me-2"></i>Applications
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="admin-users.php">
                                <i class="fas fa-user-shield me-2"></i>Admin Users
                            </a>
                        </li>
                    </ul>
                </div>
            </nav>

            <!-- Main Content -->
            <main class="col-md-9 col-lg-10 px-md-4">
                <div class="py-4">
                    <h1 class="h2 mb-4">
                        <i class="fas fa-tachometer-alt me-2"></i>Admin Dashboard
                    </h1>

                    <!-- Statistics Cards -->
                    <div class="row mb-4">
                        <div class="col-xl-2 col-md-4 col-sm-6 mb-3">
                            <div class="card dashboard-card text-center">
                                <div class="card-body">
                                    <div class="text-primary mb-2">
                                        <i class="fas fa-building fa-2x"></i>
                                    </div>
                                    <h3 class="fw-bold"><?php echo $stats['total_companies']; ?></h3>
                                    <p class="text-muted mb-0">Companies</p>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-xl-2 col-md-4 col-sm-6 mb-3">
                            <div class="card dashboard-card text-center">
                                <div class="card-body">
                                    <div class="text-warning mb-2">
                                        <i class="fas fa-clock fa-2x"></i>
                                    </div>
                                    <h3 class="fw-bold"><?php echo $stats['pending_companies']; ?></h3>
                                    <p class="text-muted mb-0">Pending</p>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-xl-2 col-md-4 col-sm-6 mb-3">
                            <div class="card dashboard-card text-center">
                                <div class="card-body">
                                    <div class="text-success mb-2">
                                        <i class="fas fa-users fa-2x"></i>
                                    </div>
                                    <h3 class="fw-bold"><?php echo $stats['total_candidates']; ?></h3>
                                    <p class="text-muted mb-0">Candidates</p>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-xl-2 col-md-4 col-sm-6 mb-3">
                            <div class="card dashboard-card text-center">
                                <div class="card-body">
                                    <div class="text-info mb-2">
                                        <i class="fas fa-briefcase fa-2x"></i>
                                    </div>
                                    <h3 class="fw-bold"><?php echo $stats['total_jobs']; ?></h3>
                                    <p class="text-muted mb-0">Total Jobs</p>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-xl-2 col-md-4 col-sm-6 mb-3">
                            <div class="card dashboard-card text-center">
                                <div class="card-body">
                                    <div class="text-success mb-2">
                                        <i class="fas fa-check-circle fa-2x"></i>
                                    </div>
                                    <h3 class="fw-bold"><?php echo $stats['active_jobs']; ?></h3>
                                    <p class="text-muted mb-0">Active Jobs</p>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-xl-2 col-md-4 col-sm-6 mb-3">
                            <div class="card dashboard-card text-center">
                                <div class="card-body">
                                    <div class="text-primary mb-2">
                                        <i class="fas fa-file-alt fa-2x"></i>
                                    </div>
                                    <h3 class="fw-bold"><?php echo $stats['total_applications']; ?></h3>
                                    <p class="text-muted mb-0">Applications</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Recent Activity -->
                    <div class="row">
                        <!-- Recent Companies -->
                        <div class="col-lg-6 mb-4">
                            <div class="card h-100">
                                <div class="card-header">
                                    <h5 class="card-title mb-0">
                                        <i class="fas fa-building me-2"></i>Recent Companies
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <?php if (empty($recent_companies)): ?>
                                        <p class="text-muted">No companies registered yet.</p>
                                    <?php else: ?>
                                        <div class="list-group list-group-flush">
                                            <?php foreach ($recent_companies as $company): ?>
                                                <div class="list-group-item d-flex justify-content-between align-items-center px-0">
                                                    <div>
                                                        <h6 class="mb-1"><?php echo htmlspecialchars($company['name']); ?></h6>
                                                        <small class="text-muted"><?php echo htmlspecialchars($company['email']); ?></small>
                                                    </div>
                                                    <span class="badge status-<?php echo $company['status']; ?>">
                                                        <?php echo ucfirst($company['status']); ?>
                                                    </span>
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                        <div class="mt-3">
                                            <a href="companies.php" class="btn btn-sm btn-outline-primary">View All Companies</a>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <!-- Recent Candidates -->
                        <div class="col-lg-6 mb-4">
                            <div class="card h-100">
                                <div class="card-header">
                                    <h5 class="card-title mb-0">
                                        <i class="fas fa-users me-2"></i>Recent Candidates
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <?php if (empty($recent_candidates)): ?>
                                        <p class="text-muted">No candidates registered yet.</p>
                                    <?php else: ?>
                                        <div class="list-group list-group-flush">
                                            <?php foreach ($recent_candidates as $candidate): ?>
                                                <div class="list-group-item d-flex justify-content-between align-items-center px-0">
                                                    <div>
                                                        <h6 class="mb-1"><?php echo htmlspecialchars($candidate['first_name'] . ' ' . $candidate['last_name']); ?></h6>
                                                        <small class="text-muted"><?php echo htmlspecialchars($candidate['email']); ?></small>
                                                    </div>
                                                    <small class="text-muted"><?php echo formatDate($candidate['created_at']); ?></small>
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                        <div class="mt-3">
                                            <a href="candidates.php" class="btn btn-sm btn-outline-primary">View All Candidates</a>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Quick Actions -->
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">
                                <i class="fas fa-bolt me-2"></i>Quick Actions
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-3 mb-2">
                                    <a href="companies.php" class="btn btn-outline-primary w-100">
                                        <i class="fas fa-building me-2"></i>Manage Companies
                                    </a>
                                </div>
                                <div class="col-md-3 mb-2">
                                    <a href="candidates.php" class="btn btn-outline-success w-100">
                                        <i class="fas fa-users me-2"></i>View Candidates
                                    </a>
                                </div>
                                <div class="col-md-3 mb-2">
                                    <a href="categories.php" class="btn btn-outline-info w-100">
                                        <i class="fas fa-tags me-2"></i>Job Categories
                                    </a>
                                </div>
                                <div class="col-md-3 mb-2">
                                    <a href="applications.php" class="btn btn-outline-warning w-100">
                                        <i class="fas fa-file-alt me-2"></i>Applications
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>