<?php
// Test view-company.php functionality
require_once 'config/config.php';

$database = new Database();
$db = $database->getConnection();

try {
    // Test the jobs query from view-company.php
    $company_id = 1; // Use the migrated company
    
    $stmt = $db->prepare("
        SELECT j.*, jc.name as category_name, cu.name as posted_by
        FROM jobs j 
        LEFT JOIN job_categories jc ON j.category_id = jc.id
        LEFT JOIN company_users cu ON j.company_user_id = cu.id
        WHERE j.company_id = ? 
        ORDER BY j.created_at DESC 
        LIMIT 5
    ");
    $stmt->execute([$company_id]);
    $recent_jobs = $stmt->fetchAll();
    
    echo "Jobs query successful!\n";
    echo "Found " . count($recent_jobs) . " jobs for company ID $company_id:\n";
    
    foreach ($recent_jobs as $job) {
        echo "- {$job['title']} (Posted by: {$job['posted_by']})\n";
        echo "  Status: {$job['status']}\n";
        echo "  Category: {$job['category_name']}\n\n";
    }
    
    // Test company users query
    $stmt = $db->prepare("
        SELECT * FROM company_users 
        WHERE company_id = ? 
        ORDER BY is_primary DESC, created_at ASC
    ");
    $stmt->execute([$company_id]);
    $company_users = $stmt->fetchAll();
    
    echo "Company users query successful!\n";
    echo "Found " . count($company_users) . " users for company ID $company_id:\n";
    
    foreach ($company_users as $user) {
        echo "- {$user['name']} ({$user['email']})";
        if ($user['is_primary']) echo " [PRIMARY]";
        echo " - Status: {$user['status']}\n";
    }
    
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>