<?php
// Check current database structure
require_once 'config/config.php';

$database = new Database();
$db = $database->getConnection();

try {
    // Show all tables
    $stmt = $db->query("SHOW TABLES");
    $tables = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    echo "Current tables in database:\n";
    foreach ($tables as $table) {
        echo "- $table\n";
    }
    
    // Check if company_users table exists
    if (!in_array('company_users', $tables)) {
        echo "\ncompany_users table is missing!\n";
        
        // Create the table
        $sql = "CREATE TABLE company_users (
            id INT PRIMARY KEY AUTO_INCREMENT,
            company_id INT NOT NULL,
            name VARCHAR(100) NOT NULL,
            email VARCHAR(100) UNIQUE NOT NULL,
            password VARCHAR(255) NOT NULL,
            phone VARCHAR(20),
            position VARCHAR(100),
            is_primary BOOLEAN DEFAULT FALSE,
            status ENUM('active', 'inactive') DEFAULT 'active',
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            FOREIGN KEY (company_id) REFERENCES companies(id) ON DELETE CASCADE
        )";
        
        $db->exec($sql);
        echo "company_users table created successfully!\n";
    } else {
        echo "\ncompany_users table exists.\n";
    }
    
    // Check companies table structure
    $stmt = $db->query("DESCRIBE companies");
    $columns = $stmt->fetchAll();
    
    echo "\nCompanies table structure:\n";
    foreach ($columns as $column) {
        echo "- {$column['Field']} ({$column['Type']})\n";
    }
    
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>