<?php
require_once 'config/config.php';

$database = new Database();
$db = $database->getConnection();

echo "<h2>🧪 Test Profile Fix - Simulate Login</h2>\n";

$users = [
    ['name' => 'Melissa', 'email' => 'melissa.makoma@petrosa.co.za'],
    ['name' => 'Brian', 'email' => 'brianvukile.peter@sa-npc.co.za']
];

foreach ($users as $user) {
    echo "<h3>Testing: {$user['name']}</h3>\n";
    
    // Simulate login - get user data
    $stmt = $db->prepare("SELECT * FROM candidates WHERE email = ?");
    $stmt->execute([$user['email']]);
    $candidate = $stmt->fetch();
    
    if ($candidate) {
        echo "<div style='background: #f8f9fa; padding: 15px; border-radius: 5px; margin: 10px 0;'>\n";
        echo "<h4>Login Simulation for {$user['name']}:</h4>\n";
        echo "<p><strong>Session user_id would be:</strong> {$candidate['id']}</p>\n";
        echo "<p><strong>Session first_name would be:</strong> {$candidate['first_name']}</p>\n";
        echo "<p><strong>Session last_name would be:</strong> {$candidate['last_name']}</p>\n";
        echo "<p><strong>Session user_email would be:</strong> {$candidate['email']}</p>\n";
        echo "</div>\n";
        
        // Simulate dashboard query - what profile data would be retrieved
        echo "<h4>Dashboard Profile Query Result:</h4>\n";
        $stmt = $db->prepare("SELECT * FROM candidates WHERE id = ?");
        $stmt->execute([$candidate['id']]);
        $profile_data = $stmt->fetch();
        
        if ($profile_data) {
            echo "<div style='background: #e8f5e8; padding: 15px; border-radius: 5px; margin: 10px 0;'>\n";
            echo "<p><strong>Profile Name:</strong> {$profile_data['first_name']} {$profile_data['last_name']}</p>\n";
            echo "<p><strong>Profile Email:</strong> {$profile_data['email']}</p>\n";
            echo "<p><strong>Profile ID:</strong> {$profile_data['id']}</p>\n";
            echo "<p><strong>Profile Type:</strong> {$profile_data['candidate_type']}</p>\n";
            echo "<p><strong>Profile Company:</strong> {$profile_data['company_id']}</p>\n";
            
            // Check if session data matches profile data
            $session_matches_profile = (
                $candidate['id'] == $profile_data['id'] &&
                $candidate['first_name'] == $profile_data['first_name'] &&
                $candidate['email'] == $profile_data['email']
            );
            
            if ($session_matches_profile) {
                echo "<div style='background: #d4edda; color: #155724; padding: 10px; border-radius: 3px; margin-top: 10px;'>\n";
                echo "✅ <strong>CORRECT!</strong> Session data matches profile data\n";
                echo "</div>\n";
            } else {
                echo "<div style='background: #f8d7da; color: #721c24; padding: 10px; border-radius: 3px; margin-top: 10px;'>\n";
                echo "❌ <strong>ERROR!</strong> Session data doesn't match profile data\n";
                echo "</div>\n";
            }
            echo "</div>\n";
        } else {
            echo "<p>❌ No profile data found for ID: {$candidate['id']}</p>\n";
        }
    } else {
        echo "<p>❌ Login would fail - user not found</p>\n";
    }
    
    echo "<hr>\n";
}

// Test the actual menu name that would be displayed
echo "<h3>Menu Name Test</h3>\n";
echo "<p>What would appear in the top menu after login:</p>\n";

foreach ($users as $user) {
    $stmt = $db->prepare("SELECT first_name, last_name FROM candidates WHERE email = ?");
    $stmt->execute([$user['email']]);
    $menu_data = $stmt->fetch();
    
    if ($menu_data) {
        echo "<div style='background: #f8f9fa; padding: 10px; border: 1px solid #dee2e6; border-radius: 5px; margin: 5px 0;'>\n";
        echo "<strong>{$user['name']}'s Menu:</strong> Welcome, {$menu_data['first_name']} {$menu_data['last_name']}\n";
        echo "</div>\n";
    }
}

echo "<h3>🎯 Expected Results</h3>\n";
echo "<div style='background: #d1ecf1; color: #0c5460; padding: 15px; border-radius: 5px; margin: 10px 0;'>\n";
echo "<h4>When Melissa logs in:</h4>\n";
echo "<ul>\n";
echo "<li>Menu should show: <strong>Welcome, Melissa Makoma</strong></li>\n";
echo "<li>Profile should show: <strong>Melissa Makoma's data</strong></li>\n";
echo "<li>Session user_id: <strong>15</strong></li>\n";
echo "</ul>\n";
echo "<h4>When Brian logs in:</h4>\n";
echo "<ul>\n";
echo "<li>Menu should show: <strong>Welcome, Brian vukile Peter</strong></li>\n";
echo "<li>Profile should show: <strong>Brian vukile Peter's data</strong></li>\n";
echo "<li>Session user_id: <strong>14</strong></li>\n";
echo "</ul>\n";
echo "</div>\n";

?>

<style>
body { font-family: Arial, sans-serif; margin: 20px; line-height: 1.6; }
table { width: 100%; margin: 20px 0; border-collapse: collapse; }
th, td { padding: 8px; text-align: left; border: 1px solid #ddd; }
th { background-color: #f2f2f2; }
h1, h2, h3, h4 { color: #333; }
</style>