<?php
// Simple test to verify the dummy score generation functionality
require_once 'config/config.php';

$database = new Database();
$db = $database->getConnection();

// Test database connection
echo "Database connection: ";
if ($db) {
    echo "✓ Connected\n";
} else {
    echo "✗ Failed\n";
    exit;
}

// Check if total_score column exists
echo "Checking total_score column: ";
$stmt = $db->query("SHOW COLUMNS FROM job_applications LIKE 'total_score'");
if ($stmt->fetch()) {
    echo "✓ Exists\n";
} else {
    echo "✗ Missing\n";
    exit;
}

// Count applications without scores
$stmt = $db->prepare("
    SELECT COUNT(*) as count 
    FROM job_applications 
    WHERE (total_score IS NULL OR total_score = 0)
");
$stmt->execute();
$result = $stmt->fetch();

echo "Applications without scores: " . $result['count'] . "\n";

if ($result['count'] > 0) {
    echo "✓ Ready to generate dummy scores\n";
    echo "Run generate_dummy_scores.php in your browser to populate scores\n";
} else {
    echo "All applications already have scores\n";
}
?>