<?php
require_once 'config/config.php';

echo "<h2>Quick Fix: Adding job_visibility Column</h2>\n";

try {
    $database = new Database();
    $db = $database->getConnection();
    
    echo "<p>✓ Database connection successful</p>\n";
    
    // Check if job_visibility column already exists
    $stmt = $db->query("SHOW COLUMNS FROM jobs LIKE 'job_visibility'");
    if ($stmt->fetch()) {
        echo "<div style='color: orange; padding: 10px; background: #fff3cd; border: 1px solid #ffeaa7; border-radius: 5px;'>\n";
        echo "⚠ job_visibility column already exists in jobs table.\n";
        echo "</div>\n";
    } else {
        echo "<p>Adding job_visibility column to jobs table...</p>\n";
        
        // Add the column
        $db->exec("ALTER TABLE jobs ADD COLUMN job_visibility ENUM('external', 'internal', 'both') DEFAULT 'external' AFTER experience_level");
        echo "<div style='color: green;'>✓ Added job_visibility column</div>\n";
        
        // Update existing jobs to be external by default
        $updated = $db->exec("UPDATE jobs SET job_visibility = 'external' WHERE job_visibility IS NULL");
        echo "<div style='color: green;'>✓ Updated $updated existing jobs to 'external' visibility</div>\n";
        
        // Add index for better performance
        try {
            $db->exec("ALTER TABLE jobs ADD INDEX idx_job_visibility (job_visibility)");
            echo "<div style='color: green;'>✓ Added index for job_visibility</div>\n";
        } catch (PDOException $e) {
            echo "<div style='color: orange;'>⚠ Index might already exist</div>\n";
        }
    }
    
    // Verify the column was added
    echo "<h3>Verification:</h3>\n";
    $stmt = $db->query("DESCRIBE jobs");
    $columns = $stmt->fetchAll();
    
    $job_visibility_found = false;
    foreach ($columns as $column) {
        if ($column['Field'] === 'job_visibility') {
            $job_visibility_found = true;
            echo "<div style='color: green;'>✓ job_visibility column exists</div>\n";
            echo "<p><strong>Column details:</strong> {$column['Type']}, Default: {$column['Default']}</p>\n";
            break;
        }
    }
    
    if ($job_visibility_found) {
        // Test the jobs query
        echo "<h3>Testing Jobs Query:</h3>\n";
        try {
            $stmt = $db->query("SELECT COUNT(*) as count, job_visibility FROM jobs GROUP BY job_visibility");
            $results = $stmt->fetchAll();
            
            echo "<p><strong>Current job visibility distribution:</strong></p>\n";
            echo "<ul>\n";
            foreach ($results as $result) {
                echo "<li>{$result['job_visibility']}: {$result['count']} jobs</li>\n";
            }
            echo "</ul>\n";
            
            echo "<div style='color: green; padding: 15px; background: #d4edda; border: 1px solid #c3e6cb; margin: 20px 0; border-radius: 5px;'>\n";
            echo "<h4>🎉 SUCCESS!</h4>\n";
            echo "<p>The job_visibility column has been added successfully!</p>\n";
            echo "<p><strong>You can now:</strong></p>\n";
            echo "<ul>\n";
            echo "<li>View job listings without errors</li>\n";
            echo "<li>Post new jobs with visibility options</li>\n";
            echo "<li>See visibility badges on job listings</li>\n";
            echo "</ul>\n";
            echo "<p><a href='jobs.php' style='background: #28a745; color: white; padding: 10px 20px; text-decoration: none; border-radius: 4px; margin-right: 10px;'>View Job Listings</a>\n";
            echo "<a href='company/post-job.php' style='background: #007bff; color: white; padding: 10px 20px; text-decoration: none; border-radius: 4px;'>Post New Job</a></p>\n";
            echo "</div>\n";
            
        } catch (PDOException $e) {
            echo "<div style='color: red;'>✗ Error testing query: " . $e->getMessage() . "</div>\n";
        }
    } else {
        echo "<div style='color: red; padding: 15px; background: #f8d7da; border: 1px solid #f5c6cb; margin: 20px 0; border-radius: 5px;'>\n";
        echo "<h4>❌ Column still not found!</h4>\n";
        echo "<p>There may be a database permission issue. Please check your database configuration.</p>\n";
        echo "</div>\n";
    }
    
} catch (Exception $e) {
    echo "<div style='color: red; padding: 15px; background: #f8d7da; border: 1px solid #f5c6cb; margin: 20px 0; border-radius: 5px;'>\n";
    echo "<strong>Error:</strong> " . $e->getMessage() . "<br>\n";
    echo "<strong>File:</strong> " . $e->getFile() . "<br>\n";
    echo "<strong>Line:</strong> " . $e->getLine() . "\n";
    echo "</div>\n";
}
?>