<?php
require_once 'config/config.php';

$database = new Database();
$db = $database->getConnection();

echo "<h2>🔧 Fix Login Issues for Sisanda & Brian</h2>\n";

// 1. Fix Brian's duplicate records
echo "<h3>1. Fixing Brian's Duplicate Records</h3>\n";

// First, get all Brian records
$stmt = $db->prepare("SELECT * FROM candidates WHERE email = 'brianvukile.peter@sa-npc.co.za' ORDER BY created_at DESC");
$stmt->execute();
$brian_records = $stmt->fetchAll();

echo "<p>Found " . count($brian_records) . " records for Brian.</p>\n";

if (count($brian_records) > 1) {
    // Keep the most recent record, delete the others
    $keep_record = $brian_records[0]; // Most recent
    
    echo "<p>Keeping record ID: {$keep_record['id']} (created: {$keep_record['created_at']})</p>\n";
    
    // Delete duplicate records
    for ($i = 1; $i < count($brian_records); $i++) {
        $record = $brian_records[$i];
        $stmt = $db->prepare("DELETE FROM candidates WHERE id = ? AND email = 'brianvukile.peter@sa-npc.co.za'");
        $result = $stmt->execute([$record['id']]);
        
        if ($result) {
            echo "<p>✅ Deleted duplicate record ID: {$record['id']}</p>\n";
        } else {
            echo "<p>❌ Failed to delete record ID: {$record['id']}</p>\n";
        }
    }
    
    // Update the kept record to ensure it has a proper ID if it's 0
    if ($keep_record['id'] == 0) {
        echo "<p>⚠️ Record has invalid ID (0), this needs manual database repair</p>\n";
    }
}

// 2. Reset passwords for both users
echo "<h3>2. Reset Passwords</h3>\n";

$users = [
    ['email' => 'sisanda.mbodlela@sanpc.co.za', 'password' => 'Sisanda123'],
    ['email' => 'brianvukile.peter@sa-npc.co.za', 'password' => 'Brian123']
];

foreach ($users as $user) {
    $hashed_password = password_hash($user['password'], PASSWORD_DEFAULT);
    
    $stmt = $db->prepare("UPDATE candidates SET password = ? WHERE email = ?");
    $result = $stmt->execute([$hashed_password, $user['email']]);
    
    if ($result && $stmt->rowCount() > 0) {
        echo "<p>✅ Password updated for {$user['email']} - New password: <strong>{$user['password']}</strong></p>\n";
    } else {
        echo "<p>❌ Failed to update password for {$user['email']}</p>\n";
    }
}

// 3. Verify the fixes
echo "<h3>3. Verification</h3>\n";

foreach (['sisanda.mbodlela@sanpc.co.za', 'brianvukile.peter@sa-npc.co.za'] as $email) {
    $stmt = $db->prepare("SELECT id, first_name, last_name, email, candidate_type, hr_approval_status FROM candidates WHERE email = ?");
    $stmt->execute([$email]);
    $user = $stmt->fetch();
    
    if ($user) {
        echo "<div style='background: #d4edda; padding: 10px; margin: 10px 0; border-radius: 5px;'>\n";
        echo "<h4>✅ {$user['first_name']} {$user['last_name']}</h4>\n";
        echo "<p><strong>Email:</strong> {$user['email']}</p>\n";
        echo "<p><strong>ID:</strong> {$user['id']}</p>\n";
        echo "<p><strong>Type:</strong> {$user['candidate_type']}</p>\n";
        echo "<p><strong>Status:</strong> {$user['hr_approval_status']}</p>\n";
        echo "</div>\n";
    }
}

// 4. Login test instructions
echo "<h3>4. Login Test Instructions</h3>\n";
echo "<div style='background: #f8f9fa; padding: 15px; border: 1px solid #dee2e6; border-radius: 5px;'>\n";
echo "<h4>🔑 New Login Credentials:</h4>\n";
echo "<p><strong>Sisanda Mbodlela:</strong></p>\n";
echo "<ul>\n";
echo "<li>Email: sisanda.mbodlela@sanpc.co.za</li>\n";
echo "<li>Password: Sisanda123</li>\n";
echo "<li>Login as: Candidate</li>\n";
echo "</ul>\n";

echo "<p><strong>Brian Peter:</strong></p>\n";
echo "<ul>\n";
echo "<li>Email: brianvukile.peter@sa-npc.co.za</li>\n";
echo "<li>Password: Brian123</li>\n";
echo "<li>Login as: Candidate</li>\n";
echo "</ul>\n";

echo "<p><a href='auth/login.php' style='background: #007bff; color: white; padding: 10px 20px; text-decoration: none; border-radius: 4px;'>🔗 Go to Login Page</a></p>\n";
echo "</div>\n";

?>

<style>
body { font-family: Arial, sans-serif; margin: 20px; line-height: 1.6; }
table { width: 100%; margin: 20px 0; border-collapse: collapse; }
th, td { padding: 10px; text-align: left; border: 1px solid #ddd; }
th { background-color: #f2f2f2; }
h1, h2, h3 { color: #333; }
</style>