<?php
require_once 'config/config.php';

$database = new Database();
$db = $database->getConnection();

echo "Debugging Last Application Status Changes During Downloads\n";
echo "========================================================\n\n";

// Get all applications for SANPC (company_id = 8) ordered by ID
$stmt = $db->prepare("
    SELECT ja.id, ja.status, ja.candidate_id, ja.job_id, ja.applied_at,
           c.first_name, c.last_name, j.title as job_title
    FROM job_applications ja 
    JOIN candidates c ON ja.candidate_id = c.id 
    JOIN jobs j ON ja.job_id = j.id
    WHERE j.company_id = 8
    ORDER BY ja.id ASC
");
$stmt->execute();
$applications = $stmt->fetchAll();

echo "Current applications for SANPC (company_id = 8):\n";
foreach ($applications as $index => $app) {
    $position = $index + 1;
    $last_marker = ($index === count($applications) - 1) ? " ← LAST APPLICATION" : "";
    echo "{$position}. App ID: {$app['id']}, Status: {$app['status']}, Candidate: {$app['first_name']} {$app['last_name']}, Job: {$app['job_title']}{$last_marker}\n";
}

$last_app = end($applications);
if ($last_app) {
    echo "\nFocusing on LAST APPLICATION:\n";
    echo "- Application ID: {$last_app['id']}\n";
    echo "- Current Status: {$last_app['status']}\n";
    echo "- Candidate: {$last_app['first_name']} {$last_app['last_name']}\n";
    echo "- Job: {$last_app['job_title']}\n";
    echo "- Applied At: {$last_app['applied_at']}\n";
}

echo "\nChecking for patterns in applications.php that might affect the last item:\n";

// Check if there's any loop logic that might affect the last iteration
$apps_file = 'C:/xampp/htdocs/recruit/company/applications.php';
if (file_exists($apps_file)) {
    $content = file_get_contents($apps_file);
    
    // Check for any logic that might specifically target the last item
    $patterns_to_check = [
        'end(' => 'Using end() function',
        'array_pop(' => 'Using array_pop() function',
        'count(' => 'Using count() function',
        'foreach.*as.*$application.*{' => 'Foreach loop structure',
        '\$applications\[.*\]' => 'Direct array access',
        'last.*application' => 'Text mentioning "last application"'
    ];
    
    foreach ($patterns_to_check as $pattern => $description) {
        if (preg_match("/$pattern/i", $content)) {
            echo "✓ Found: $description\n";
        }
    }
}

echo "\nChecking bulk_download.php for any status modifications:\n";
$download_file = 'C:/xampp/htdocs/recruit/company/bulk_download.php';
if (file_exists($download_file)) {
    $download_content = file_get_contents($download_file);
    
    // Check for any UPDATE statements
    if (preg_match('/UPDATE.*job_applications/i', $download_content)) {
        echo "⚠️  FOUND: bulk_download.php contains UPDATE statements on job_applications!\n";
    } else {
        echo "✓ bulk_download.php does not contain UPDATE statements on job_applications\n";
    }
    
    // Check for any status modifications
    if (preg_match('/status.*=/i', $download_content)) {
        echo "⚠️  FOUND: bulk_download.php contains status assignments!\n";
    } else {
        echo "✓ bulk_download.php does not contain status assignments\n";
    }
}

echo "\nSimulating download scenario:\n";
echo "If applications were processed in a loop and download_zip was selected,\n";
echo "the issue might be in the foreach loop in applications.php around line 106.\n";

// Check if there's any issue with the foreach loop structure
echo "\nRecommendations:\n";
echo "1. Check if the foreach loop continues after the download redirect\n";
echo "2. Verify that exit; actually stops execution\n";
echo "3. Look for any code that processes the last application differently\n";
echo "4. Check browser developer tools for multiple form submissions\n";
echo "5. Monitor network requests during download to see if multiple requests are made\n";
?>