<?php
require_once '../config/config.php';
requireLogin('company');

$database = new Database();
$db = $database->getConnection();

$company_id = $_SESSION['company_id'];

// Get company statistics
$stats = [];

// Total jobs posted
$stmt = $db->prepare("SELECT COUNT(*) as count FROM jobs WHERE company_id = ?");
$stmt->execute([$company_id]);
$stats['total_jobs'] = $stmt->fetch()['count'];

// Active jobs
$stmt = $db->prepare("SELECT COUNT(*) as count FROM jobs WHERE company_id = ? AND status = 'active'");
$stmt->execute([$company_id]);
$stats['active_jobs'] = $stmt->fetch()['count'];

// Total applications received
$stmt = $db->prepare("
    SELECT COUNT(*) as count 
    FROM job_applications ja 
    JOIN jobs j ON ja.job_id = j.id 
    WHERE j.company_id = ?
");
$stmt->execute([$company_id]);
$stats['total_applications'] = $stmt->fetch()['count'];

// Pending applications
$stmt = $db->prepare("
    SELECT COUNT(*) as count 
    FROM job_applications ja 
    JOIN jobs j ON ja.job_id = j.id 
    WHERE j.company_id = ? AND ja.status = 'applied'
");
$stmt->execute([$company_id]);
$stats['pending_applications'] = $stmt->fetch()['count'];

// Internal employees pending approval
$stmt = $db->prepare("
    SELECT COUNT(*) as count 
    FROM candidates 
    WHERE candidate_type = 'internal' AND company_id = ? AND hr_approval_status = 'pending'
");
$stmt->execute([$company_id]);
$stats['pending_internal_employees'] = $stmt->fetch()['count'];

// Total internal employees
$stmt = $db->prepare("
    SELECT COUNT(*) as count 
    FROM candidates 
    WHERE candidate_type = 'internal' AND company_id = ?
");
$stmt->execute([$company_id]);
$stats['total_internal_employees'] = $stmt->fetch()['count'];

// Get pending internal employees for quick approval widget
$stmt = $db->prepare("
    SELECT id, first_name, last_name, email, employee_code, created_at
    FROM candidates 
    WHERE candidate_type = 'internal' AND company_id = ? AND hr_approval_status = 'pending'
    ORDER BY created_at DESC
    LIMIT 5
");
$stmt->execute([$company_id]);
$pending_employees = $stmt->fetchAll();

// Recent jobs
$stmt = $db->prepare("
    SELECT j.*, cat.name as category_name,
           COUNT(ja.id) as application_count
    FROM jobs j 
    LEFT JOIN job_categories cat ON j.category_id = cat.id 
    LEFT JOIN job_applications ja ON j.id = ja.job_id
    WHERE j.company_id = ? 
    GROUP BY j.id
    ORDER BY j.created_at DESC 
    LIMIT 5
");
$stmt->execute([$company_id]);
$recent_jobs = $stmt->fetchAll();

// Recent applications
$stmt = $db->prepare("
    SELECT ja.*, j.title as job_title, 
           c.first_name, c.last_name, c.email
    FROM job_applications ja
    JOIN jobs j ON ja.job_id = j.id
    JOIN candidates c ON ja.candidate_id = c.id
    WHERE j.company_id = ?
    ORDER BY ja.applied_at DESC
    LIMIT 5
");
$stmt->execute([$company_id]);
$recent_applications = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Company Dashboard - <?php echo SITE_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="../assets/css/style.css" rel="stylesheet">
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container-fluid">
            <a class="navbar-brand" href="../index.php">
                <i class="fas fa-briefcase me-2"></i><?php echo SITE_NAME; ?>
            </a>
            
            <div class="navbar-nav ms-auto">
                <span class="navbar-text me-3">
                    Welcome, <?php echo htmlspecialchars($_SESSION['company_name']); ?>
                </span>
                <a class="nav-link" href="../auth/logout.php">
                    <i class="fas fa-sign-out-alt me-1"></i>Logout
                </a>
            </div>
        </div>
    </nav>

    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <nav class="col-md-3 col-lg-2 sidebar">
                <div class="position-sticky">
                    <ul class="nav flex-column">
                        <li class="nav-item">
                            <a class="nav-link active" href="dashboard.php">
                                <i class="fas fa-tachometer-alt me-2"></i>Dashboard
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="profile.php">
                                <i class="fas fa-building me-2"></i>Company Profile
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="jobs.php">
                                <i class="fas fa-briefcase me-2"></i>Manage Jobs
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="post-job.php">
                                <i class="fas fa-plus-circle me-2"></i>Post New Job
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="applications.php">
                                <i class="fas fa-file-alt me-2"></i>Applications
                                <?php if ($stats['pending_applications'] > 0): ?>
                                    <span class="badge bg-warning ms-2"><?php echo $stats['pending_applications']; ?></span>
                                <?php endif; ?>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="internal-employees.php">
                                <i class="fas fa-users me-2"></i>Internal Employees
                                <?php if ($stats['pending_internal_employees'] > 0): ?>
                                    <span class="badge bg-danger ms-2"><?php echo $stats['pending_internal_employees']; ?></span>
                                <?php endif; ?>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="interviews.php">
                                <i class="fas fa-calendar-alt me-2"></i>Interviews
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="hr-analytics.php">
                                <i class="fas fa-chart-line me-2"></i>HR Analytics
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="change-password.php">
                                <i class="fas fa-lock me-2"></i>Change Password
                            </a>
                        </li>
                    </ul>
                </div>
            </nav>

            <!-- Main Content -->
            <main class="col-md-9 col-lg-10 px-md-4">
                <div class="py-4">
                    <h1 class="h2 mb-4">
                        <i class="fas fa-tachometer-alt me-2"></i>Company Dashboard
                    </h1>

                    <!-- Statistics Cards -->
                    <div class="row mb-4">
                        <div class="col-xl-3 col-md-6 mb-3">
                            <div class="card dashboard-card text-center">
                                <div class="card-body">
                                    <div class="text-primary mb-2">
                                        <i class="fas fa-briefcase fa-2x"></i>
                                    </div>
                                    <h3 class="fw-bold"><?php echo $stats['total_jobs']; ?></h3>
                                    <p class="text-muted mb-0">Total Jobs</p>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-xl-3 col-md-6 mb-3">
                            <div class="card dashboard-card text-center">
                                <div class="card-body">
                                    <div class="text-success mb-2">
                                        <i class="fas fa-check-circle fa-2x"></i>
                                    </div>
                                    <h3 class="fw-bold"><?php echo $stats['active_jobs']; ?></h3>
                                    <p class="text-muted mb-0">Active Jobs</p>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-xl-3 col-md-6 mb-3">
                            <div class="card dashboard-card text-center">
                                <div class="card-body">
                                    <div class="text-info mb-2">
                                        <i class="fas fa-file-alt fa-2x"></i>
                                    </div>
                                    <h3 class="fw-bold"><?php echo $stats['total_applications']; ?></h3>
                                    <p class="text-muted mb-0">Total Applications</p>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-xl-3 col-md-6 mb-3">
                            <div class="card dashboard-card text-center">
                                <div class="card-body">
                                    <div class="text-warning mb-2">
                                        <i class="fas fa-clock fa-2x"></i>
                                    </div>
                                    <h3 class="fw-bold"><?php echo $stats['pending_applications']; ?></h3>
                                    <p class="text-muted mb-0">Pending</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Internal Employees Row -->
                    <div class="row mb-4">
                        <div class="col-xl-6 col-md-6 mb-3">
                            <div class="card dashboard-card text-center border-danger">
                                <div class="card-body">
                                    <div class="text-danger mb-2">
                                        <i class="fas fa-users fa-2x"></i>
                                    </div>
                                    <h3 class="fw-bold text-danger"><?php echo $stats['pending_internal_employees']; ?></h3>
                                    <p class="text-muted mb-2">Internal Employees Pending Approval</p>
                                    <?php if ($stats['pending_internal_employees'] > 0): ?>
                                        <a href="internal-employees.php?filter=pending" class="btn btn-danger btn-sm">
                                            <i class="fas fa-eye me-1"></i>Review Now
                                        </a>
                                    <?php else: ?>
                                        <span class="text-success small"><i class="fas fa-check"></i> All caught up!</span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-xl-6 col-md-6 mb-3">
                            <div class="card dashboard-card text-center">
                                <div class="card-body">
                                    <div class="text-success mb-2">
                                        <i class="fas fa-user-check fa-2x"></i>
                                    </div>
                                    <h3 class="fw-bold"><?php echo $stats['total_internal_employees']; ?></h3>
                                    <p class="text-muted mb-2">Total Internal Employees</p>
                                    <a href="internal-employees.php" class="btn btn-outline-success btn-sm">
                                        <i class="fas fa-users me-1"></i>Manage All
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Quick Actions -->
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="card-title mb-0">
                                <i class="fas fa-bolt me-2"></i>Quick Actions
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-lg-3 col-md-6 mb-2">
                                    <a href="post-job.php" class="btn btn-primary w-100">
                                        <i class="fas fa-plus-circle me-2"></i>Post New Job
                                    </a>
                                </div>
                                <div class="col-lg-3 col-md-6 mb-2">
                                    <a href="applications.php" class="btn btn-outline-warning w-100">
                                        <i class="fas fa-file-alt me-2"></i>View Applications
                                        <?php if ($stats['pending_applications'] > 0): ?>
                                            <span class="badge bg-warning text-dark ms-1"><?php echo $stats['pending_applications']; ?></span>
                                        <?php endif; ?>
                                    </a>
                                </div>
                                <div class="col-lg-3 col-md-6 mb-2">
                                    <a href="internal-employees.php" class="btn <?php echo ($stats['pending_internal_employees'] > 0) ? 'btn-danger' : 'btn-outline-danger'; ?> w-100">
                                        <i class="fas fa-users me-2"></i>Internal Employees
                                        <?php if ($stats['pending_internal_employees'] > 0): ?>
                                            <span class="badge bg-white text-danger ms-1"><?php echo $stats['pending_internal_employees']; ?></span>
                                        <?php endif; ?>
                                    </a>
                                </div>
                                <div class="col-lg-3 col-md-6 mb-2">
                                    <a href="jobs.php" class="btn btn-outline-success w-100">
                                        <i class="fas fa-briefcase me-2"></i>Manage Jobs
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <!-- Recent Jobs -->
                        <div class="col-lg-6 mb-4">
                            <div class="card h-100">
                                <div class="card-header d-flex justify-content-between align-items-center">
                                    <h5 class="card-title mb-0">
                                        <i class="fas fa-briefcase me-2"></i>Recent Jobs
                                    </h5>
                                    <a href="jobs.php" class="btn btn-sm btn-outline-primary">View All</a>
                                </div>
                                <div class="card-body">
                                    <?php if (empty($recent_jobs)): ?>
                                        <div class="text-center py-3">
                                            <i class="fas fa-briefcase fa-3x text-muted mb-3"></i>
                                            <p class="text-muted">No jobs posted yet.</p>
                                            <a href="post-job.php" class="btn btn-primary">Post Your First Job</a>
                                        </div>
                                    <?php else: ?>
                                        <div class="list-group list-group-flush">
                                            <?php foreach ($recent_jobs as $job): ?>
                                                <div class="list-group-item d-flex justify-content-between align-items-center px-0">
                                                    <div>
                                                        <h6 class="mb-1"><?php echo htmlspecialchars($job['title']); ?></h6>
                                                        <small class="text-muted">
                                                            <?php echo htmlspecialchars($job['category_name']); ?> • 
                                                            <?php echo $job['application_count']; ?> applications
                                                        </small>
                                                    </div>
                                                    <span class="badge status-<?php echo $job['status']; ?>">
                                                        <?php echo ucfirst($job['status']); ?>
                                                    </span>
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <!-- Recent Applications -->
                        <div class="col-lg-6 mb-4">
                            <div class="card h-100">
                                <div class="card-header d-flex justify-content-between align-items-center">
                                    <h5 class="card-title mb-0">
                                        <i class="fas fa-file-alt me-2"></i>Recent Applications
                                    </h5>
                                    <a href="applications.php" class="btn btn-sm btn-outline-primary">View All</a>
                                </div>
                                <div class="card-body">
                                    <?php if (empty($recent_applications)): ?>
                                        <div class="text-center py-3">
                                            <i class="fas fa-file-alt fa-3x text-muted mb-3"></i>
                                            <p class="text-muted">No applications received yet.</p>
                                        </div>
                                    <?php else: ?>
                                        <div class="list-group list-group-flush">
                                            <?php foreach ($recent_applications as $application): ?>
                                                <div class="list-group-item d-flex justify-content-between align-items-center px-0">
                                                    <div>
                                                        <h6 class="mb-1"><?php echo htmlspecialchars($application['first_name'] . ' ' . $application['last_name']); ?></h6>
                                                        <small class="text-muted">
                                                            Applied for: <?php echo htmlspecialchars($application['job_title']); ?>
                                                        </small>
                                                    </div>
                                                    <div class="text-end">
                                                        <span class="badge status-<?php echo $application['status']; ?> d-block mb-1">
                                                            <?php echo ucfirst($application['status']); ?>
                                                        </span>
                                                        <small class="text-muted"><?php echo formatDate($application['applied_at']); ?></small>
                                                    </div>
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Pending Internal Employees Widget -->
                    <?php if (!empty($pending_employees)): ?>
                        <div class="row mb-4">
                            <div class="col-12">
                                <div class="card border-danger">
                                    <div class="card-header bg-danger text-white d-flex justify-content-between align-items-center">
                                        <h5 class="card-title mb-0">
                                            <i class="fas fa-exclamation-triangle me-2"></i>Internal Employees Awaiting Approval
                                        </h5>
                                        <a href="internal-employees.php?filter=pending" class="btn btn-light btn-sm">
                                            <i class="fas fa-eye me-1"></i>View All (<?php echo $stats['pending_internal_employees']; ?>)
                                        </a>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <?php foreach ($pending_employees as $employee): ?>
                                                <div class="col-lg-4 col-md-6 mb-3">
                                                    <div class="card border-warning">
                                                        <div class="card-body p-3">
                                                            <div class="d-flex align-items-center mb-2">
                                                                <div class="bg-warning rounded-circle d-flex align-items-center justify-content-center me-2" style="width: 35px; height: 35px;">
                                                                    <i class="fas fa-user text-white"></i>
                                                                </div>
                                                                <div class="flex-grow-1">
                                                                    <h6 class="mb-0"><?php echo htmlspecialchars($employee['first_name'] . ' ' . $employee['last_name']); ?></h6>
                                                                    <small class="text-muted"><?php echo htmlspecialchars($employee['email']); ?></small>
                                                                </div>
                                                            </div>
                                                            <div class="mb-2">
                                                                <span class="badge bg-secondary">ID: <?php echo htmlspecialchars($employee['employee_code']); ?></span>
                                                            </div>
                                                            <div class="d-flex gap-1">
                                                                <form method="POST" action="internal-employees.php" class="d-inline">
                                                                    <input type="hidden" name="candidate_id" value="<?php echo $employee['id']; ?>">
                                                                    <input type="hidden" name="action" value="approve">
                                                                    <button type="submit" class="btn btn-success btn-sm" onclick="return confirm('Approve this employee?')">
                                                                        <i class="fas fa-check"></i>
                                                                    </button>
                                                                </form>
                                                                <form method="POST" action="internal-employees.php" class="d-inline">
                                                                    <input type="hidden" name="candidate_id" value="<?php echo $employee['id']; ?>">
                                                                    <input type="hidden" name="action" value="reject">
                                                                    <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Reject this employee?')">
                                                                        <i class="fas fa-times"></i>
                                                                    </button>
                                                                </form>
                                                                <a href="internal-employees.php?filter=pending" class="btn btn-outline-primary btn-sm">
                                                                    <i class="fas fa-eye"></i>
                                                                </a>
                                                            </div>
                                                            <small class="text-muted mt-2 d-block">Registered: <?php echo formatDate($employee['created_at']); ?></small>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </main>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>