<?php
require_once 'config/config.php';

$database = new Database();
$db = $database->getConnection();

echo "<h2>User Account Checker</h2>\n";

// Search for users with names containing 'sisanda' or 'brian'
$search_terms = ['sisanda', 'brian'];

foreach ($search_terms as $term) {
    echo "<h3>Searching for: $term</h3>\n";
    
    // Check candidates table
    echo "<h4>Candidates:</h4>\n";
    $stmt = $db->prepare("
        SELECT id, first_name, last_name, email, candidate_type, hr_approval_status, company_id, password 
        FROM candidates 
        WHERE LOWER(first_name) LIKE ? OR LOWER(last_name) LIKE ? OR LOWER(email) LIKE ?
    ");
    $search_param = "%".strtolower($term)."%";
    $stmt->execute([$search_param, $search_param, $search_param]);
    $candidates = $stmt->fetchAll();
    
    if ($candidates) {
        echo "<table border='1' cellpadding='5'>\n";
        echo "<tr><th>ID</th><th>Name</th><th>Email</th><th>Type</th><th>Status</th><th>Company</th><th>Password Hash</th></tr>\n";
        foreach ($candidates as $candidate) {
            echo "<tr>";
            echo "<td>{$candidate['id']}</td>";
            echo "<td>{$candidate['first_name']} {$candidate['last_name']}</td>";
            echo "<td>{$candidate['email']}</td>";
            echo "<td>{$candidate['candidate_type']}</td>";
            echo "<td>{$candidate['hr_approval_status']}</td>";
            echo "<td>{$candidate['company_id']}</td>";
            echo "<td>" . (empty($candidate['password']) ? 'NO PASSWORD' : 'PASSWORD SET') . "</td>";
            echo "</tr>\n";
        }
        echo "</table>\n";
    } else {
        echo "<p>No candidates found.</p>\n";
    }
    
    // Check company_users table
    echo "<h4>Company Users:</h4>\n";
    $stmt = $db->prepare("
        SELECT id, name, email, company_id, password, status 
        FROM company_users 
        WHERE LOWER(name) LIKE ? OR LOWER(email) LIKE ?
    ");
    $stmt->execute([$search_param, $search_param]);
    $company_users = $stmt->fetchAll();
    
    if ($company_users) {
        echo "<table border='1' cellpadding='5'>\n";
        echo "<tr><th>ID</th><th>Name</th><th>Email</th><th>Company</th><th>Status</th><th>Password Hash</th></tr>\n";
        foreach ($company_users as $user) {
            echo "<tr>";
            echo "<td>{$user['id']}</td>";
            echo "<td>{$user['name']}</td>";
            echo "<td>{$user['email']}</td>";
            echo "<td>{$user['company_id']}</td>";
            echo "<td>{$user['status']}</td>";
            echo "<td>" . (empty($user['password']) ? 'NO PASSWORD' : 'PASSWORD SET') . "</td>";
            echo "</tr>\n";
        }
        echo "</table>\n";
    } else {
        echo "<p>No company users found.</p>\n";
    }
    
    // Check admins table
    echo "<h4>Admins:</h4>\n";
    $stmt = $db->prepare("
        SELECT id, username, email, password 
        FROM admins 
        WHERE LOWER(username) LIKE ? OR LOWER(email) LIKE ?
    ");
    $stmt->execute([$search_param, $search_param]);
    $admins = $stmt->fetchAll();
    
    if ($admins) {
        echo "<table border='1' cellpadding='5'>\n";
        echo "<tr><th>ID</th><th>Username</th><th>Email</th><th>Password Hash</th></tr>\n";
        foreach ($admins as $admin) {
            echo "<tr>";
            echo "<td>{$admin['id']}</td>";
            echo "<td>{$admin['username']}</td>";
            echo "<td>{$admin['email']}</td>";
            echo "<td>" . (empty($admin['password']) ? 'NO PASSWORD' : 'PASSWORD SET') . "</td>";
            echo "</tr>\n";
        }
        echo "</table>\n";
    } else {
        echo "<p>No admins found.</p>\n";
    }
    
    echo "<hr>\n";
}
?>