<?php
require_once 'config/config.php';

$database = new Database();
$db = $database->getConnection();

echo "<h2>Internal Candidates Status</h2>";

$stmt = $db->prepare("
    SELECT id, first_name, last_name, email, hr_approval_status, candidate_type, company_id 
    FROM candidates 
    WHERE candidate_type = 'internal' 
    ORDER BY hr_approval_status, id
");
$stmt->execute();
$candidates = $stmt->fetchAll();

if ($candidates) {
    echo "<table border='1' cellpadding='8' style='border-collapse: collapse;'>";
    echo "<tr style='background: #f0f0f0;'>";
    echo "<th>ID</th><th>Name</th><th>Email</th><th>Status</th><th>Company ID</th>";
    echo "</tr>";
    
    foreach ($candidates as $candidate) {
        $status_color = '';
        switch ($candidate['hr_approval_status']) {
            case 'pending': $status_color = 'orange'; break;
            case 'approved': $status_color = 'green'; break;
            case 'rejected': $status_color = 'red'; break;
            default: $status_color = 'gray';
        }
        
        echo "<tr>";
        echo "<td>{$candidate['id']}</td>";
        echo "<td>{$candidate['first_name']} {$candidate['last_name']}</td>";
        echo "<td>{$candidate['email']}</td>";
        echo "<td style='color: {$status_color}; font-weight: bold;'>" . strtoupper($candidate['hr_approval_status'] ?? 'NULL') . "</td>";
        echo "<td>{$candidate['company_id']}</td>";
        echo "</tr>";
    }
    echo "</table>";
    
    // Count by status
    $pending = array_filter($candidates, fn($c) => $c['hr_approval_status'] === 'pending');
    $approved = array_filter($candidates, fn($c) => $c['hr_approval_status'] === 'approved');
    $rejected = array_filter($candidates, fn($c) => $c['hr_approval_status'] === 'rejected');
    
    echo "<h3>Summary</h3>";
    echo "<ul>";
    echo "<li><span style='color: orange;'>Pending:</span> " . count($pending) . "</li>";
    echo "<li><span style='color: green;'>Approved:</span> " . count($approved) . "</li>";
    echo "<li><span style='color: red;'>Rejected:</span> " . count($rejected) . "</li>";
    echo "<li><strong>Total Internal Candidates:</strong> " . count($candidates) . "</li>";
    echo "</ul>";
    
} else {
    echo "<p style='color: red;'>No internal candidates found in the database.</p>";
}

// Test if we can simulate an approval
if (!empty($candidates)) {
    $test_candidate = $candidates[0];
    echo "<h3>🧪 Simulation Test</h3>";
    echo "<p>Testing approval workflow for: <strong>{$test_candidate['first_name']} {$test_candidate['last_name']}</strong></p>";
    
    // Simulate the approval process (without actually changing the database)
    try {
        require_once 'includes/gmail_email_service.php';
        $gmailService = new GmailEmailService($db);
        
        // Test email content
        $email_message = "Dear {$test_candidate['first_name']},\n\n";
        $email_message .= "Great news! Your internal employee account has been approved.\n\n";
        $email_message .= "You can now:\n";
        $email_message .= "• Log in to your account\n";
        $email_message .= "• Browse and apply for internal job postings\n";
        $email_message .= "• Update your profile and CV\n\n";
        $email_message .= "Welcome to our internal recruitment portal!\n\n";
        $email_message .= "Best regards,\nHR Team";
        
        $result = $gmailService->sendApprovalNotificationEmail($test_candidate, $email_message, 'approve');
        
        if ($result) {
            echo "<div style='background: #d4edda; color: #155724; padding: 15px; border-radius: 5px;'>";
            echo "<strong>✅ Test Email Sent Successfully!</strong><br>";
            echo "📧 Sent to: {$test_candidate['email']}<br>";
            echo "📅 Time: " . date('Y-m-d H:i:s') . "<br>";
            echo "<p>This confirms the email system is working. If you're not receiving emails when doing actual approvals, check:</p>";
            echo "<ul>";
            echo "<li>Make sure you're clicking the 'Approve' button in the admin or company interface</li>";
            echo "<li>Check the candidate's email spam/junk folder</li>";
            echo "<li>Verify the candidate's email address is correct</li>";
            echo "<li>Check error logs after approval attempts</li>";
            echo "</ul>";
            echo "</div>";
        } else {
            echo "<div style='background: #f8d7da; color: #721c24; padding: 15px; border-radius: 5px;'>";
            echo "<strong>❌ Test Email Failed</strong><br>";
            echo "Check Gmail SMTP configuration and error logs.";
            echo "</div>";
        }
        
    } catch (Exception $e) {
        echo "<div style='background: #f8d7da; color: #721c24; padding: 15px; border-radius: 5px;'>";
        echo "<strong>❌ Error during test:</strong> " . $e->getMessage();
        echo "</div>";
    }
}
?>
<style>
body { font-family: Arial, sans-serif; margin: 20px; line-height: 1.6; }
table { width: 100%; margin: 20px 0; }
th, td { padding: 10px; text-align: left; border: 1px solid #ddd; }
th { background-color: #f2f2f2; }
h2, h3 { color: #333; }
</style>