<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Email Sender</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h3 class="text-center">Send Email</h3>
                    </div>
                    <div class="card-body">
                        <?php if (isset($_GET['status'])): ?>
                            <?php if ($_GET['status'] == 'success'): ?>
                                <div class="alert alert-success">Email sent successfully!</div>
                            <?php else: ?>
                                <div class="alert alert-danger">
                                    Failed to send email. 
                                    <?php if (isset($_GET['msg'])): ?>
                                        <br><small>Error: <?php echo htmlspecialchars($_GET['msg']); ?></small>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                        <?php endif; ?>
                        
                        <form action="send_email_simple.php" method="POST">
                            <div class="mb-3">
                                <label for="to_email" class="form-label">To Email:</label>
                                <input type="email" class="form-control" id="to_email" name="to_email" required>
                            </div>
                            
                            <div class="mb-3">
                                <label for="subject" class="form-label">Subject:</label>
                                <input type="text" class="form-control" id="subject" name="subject" required>
                            </div>
                            
                            <div class="mb-3">
                                <label for="message" class="form-label">Message:</label>
                                <textarea class="form-control" id="message" name="message" rows="8" required></textarea>
                            </div>
                            
                            <div class="text-center">
                                <button type="submit" class="btn btn-primary">Send Email</button>
                                <a href="history.php" class="btn btn-secondary">View History</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>